//Note: Details of scilab software version and OS version used:
//OS: Windows 7
//Scilab version: 5.4.1
//IPD Atom version:8.3.1-2
//SIVP Atom version:0.5.3.1-2
//3.CIRCULAR CONVOLUTION OF TWO SEQUENCES
clc;
close;
clear all;
a1= input('1st Sequence x:')
b1= input('2nd Sequence h:')
ax=length(a1);
bx=length(b1);
n=max(ax,bx);
n3=ax-bx;
if(n3<=0)
 a1=[a1,zeros(1,-n3)];
else
 b1=[b1,zeros(1,n3)];
end
for r = 1:n
    y(r)=0;
    for i=1:n
        j=r-i+1;
        if (j<=0)
            j=j+n;
        end
        y(r)=y(r)+b1(j)*a1(j);
    end
end
disp(y,'circular convloution result')

subplot(3,1,1);
plot2d3('gnn',a1);
xlabel('n');
ylabel('a(n)');
title('first sequence');
subplot(3,1,2);
plot2d3('gnn',b1);
xlabel('n');
ylabel('b(n)');
title('second sequence');
subplot(3,1,3);
plot2d3('gnn',y);
xlabel('n');
ylabel('y(n)');
title('circular convolution sequence');

//RESULT
//Example 1
//1st Sequence x:[1,2,3,4]
//2nd Sequence h:[1,1,1,1]
// 
// circular convloution result   
// 
//    10.    10.    10.    10.  
//
//Example 2
//1st Sequence x:[1,2,3,4]
//2nd Sequence h:[1,1,1]
// 
// circular convloution result   
// 
//    6.    6.    6.    6.  
